% cluster composition profile
% This script looks at each cluster in a cluster data file (exported from
% IVAS), the accompanying pos file and rrng file and produces a line
% profile along the analysis direction (approximated to Z) or use the
% cluster file to get the xyz and then use the pulse number to get the true
% sequence of evaporation, then we can plot concentration or number of hits
% as a function of reconstructed z or of pulse number

f = 1; % this can be a loop later

% Input files, these could be lists
clusterFile = {'R34_05028-v02-V9.5 - Top-Level ROI - Cluster Analysis.csv'};

% rrng files
rrngFiles = {'..\R34_05028-v02.rrng'};

% pos file list
posFile = {'..\R34_05028-v02.pos'};

zs = 4; % The number of rg's to go along Z for the profile
profilePoints = 100; % number of points in the profile

% Cluster file
cf = clusterFile{f};

% Read rrng file
[element_num, range_num, rangeElements, ranges] = rangeReader(rrngFiles{f});

% Read cluster data file for all it's worth!
[elements,clusterCountsDecomp,clusterCounts,position,ionType,radii,rz,nTable,dmax,dbulk,derode,nmin,core,count] = clusterDataReaderDetailsZ(cf);
% need position and rz

% for the mass list counting:
rangeTable = cell2mat(ranges(:,[1:2 5:end])); % convert to matrix

%load pos data
[x,y,z,m] = readpos(posFile{f});
ed = [x' y' z' m']; clear x y z m
zprofile = cell(count,1); % per cluster store a cell of counts and positions
% loop through all clusters
for c = 1:count
    disp(strcat(num2str(c),'/',num2str(count))); % progress bar
    cx = position(c,1); % cluster x,y,z
    cy = position(c,2);
    cz = position(c,3);
    cr = radii(c); % fixed to 1 nm
    p = ed(:,1)>(cx-cr) & ed(:,1)<(cx+cr);
    p = p & ed(:,2)>(cy-cr) & ed(:,2)<(cy+cr);
    cr = rz(c); % current cluster radius
    p = p & ed(:,3)>(cz-zs*cr) & ed(:,3)<(cz+zs*cr); % longer than the cluster
    zprofile{c} = clusterProfileEleNP(ed(p,3),ed(p,4),rangeTable,profilePoints);
end

% export data:
% headers: profile points, real dist (nm), ID, elements
exportData = vertcat(zprofile{:});
exportTable = cell(size(exportData,1)+1, size(exportData,2)+5);
exportTable(2:end,4:end) = num2cell(exportData);
exportTable(1,1:end) = [{'x','xDist','ID','r','area'} rangeElements']; % headers
exportTable(2:end,1) = num2cell(repmat((1:profilePoints)',count,1)); % profile points 1-100 repeated
% x distance in nm, (zradius*zs*[1:profilePoints]/profilePoints) repeated
exportTable(2:end,2) = num2cell(reshape(repmat(rz',profilePoints,1),[],1).*zs./profilePoints.*cell2mat(exportTable(2:end,1)));
% ID: 1:count repeated
exportTable(2:end,3) = num2cell(reshape(repmat((1:count),profilePoints,1),[],1));
% radius
exportTable(2:end,4) = num2cell(reshape(repmat(rz',profilePoints,1),[],1));
% area, z-increment = r * (zs/profilePoints = 4/100)
exportTable(2:end,5) = num2cell(reshape(repmat((radii.^2)',profilePoints,1),[],1));
% save data:
%cell2csv('EasonLineProfiles_05028.csv',exportTable);
